/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

final class FieldSignature {
    FieldSignature() {
    }

    static String vms(Type type) {
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            Class clazz = (Class)type;
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
        } else {
            if (type instanceof Class && ((Class)type).isArray()) {
                return "[" + FieldSignature.vms(((Class)type).getComponentType());
            }
            if (type instanceof Class || type instanceof ParameterizedType) {
                return "L" + FieldSignature.fqcn(type) + ";";
            }
            if (type instanceof GenericArrayType) {
                return "[" + FieldSignature.vms(((GenericArrayType)type).getGenericComponentType());
            }
            if (type instanceof TypeVariable) {
                return "Ljava/lang/Object;";
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                if (wildcardType.getLowerBounds().length > 0) {
                    return "-" + FieldSignature.vms(wildcardType.getLowerBounds()[0]);
                }
                if (wildcardType.getUpperBounds().length > 0) {
                    Type type2 = wildcardType.getUpperBounds()[0];
                    if (type2.equals(Object.class)) {
                        return "*";
                    }
                    return "+" + FieldSignature.vms(type2);
                }
            }
        }
        throw new IllegalArgumentException("Illegal vms arg " + type);
    }

    private static String fqcn(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.getDeclaringClass() == null) {
                return clazz.getName().replace('.', '/');
            }
            return FieldSignature.fqcn(clazz.getDeclaringClass()) + "$" + clazz.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getOwnerType() == null) {
                return FieldSignature.fqcn(parameterizedType.getRawType()) + FieldSignature.args(parameterizedType);
            }
            assert (parameterizedType.getRawType() instanceof Class);
            return FieldSignature.fqcn(parameterizedType.getOwnerType()) + "." + ((Class)parameterizedType.getRawType()).getSimpleName() + FieldSignature.args(parameterizedType);
        }
        throw new IllegalArgumentException("Illegal fqcn arg = " + type);
    }

    private static String args(ParameterizedType parameterizedType) {
        StringBuilder stringBuilder = new StringBuilder("<");
        for (Type type : parameterizedType.getActualTypeArguments()) {
            stringBuilder.append(FieldSignature.vms(type));
        }
        return stringBuilder.append(">").toString();
    }
}

