/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.iosrobovm.IOSFileHandle;
import com.badlogic.gdx.files.FileHandle;
import org.robovm.apple.foundation.NSBundle;

public class IOSFiles
implements Files {
    static final String appDir = System.getenv("HOME");
    static final String externalPath = appDir + "/Documents/";
    static final String localPath = appDir + "/Library/local/";
    static final String internalPath = NSBundle.getMainBundle().getBundlePath();

    public IOSFiles() {
        new FileHandle(externalPath).mkdirs();
        new FileHandle(localPath).mkdirs();
    }

    @Override
    public FileHandle getFileHandle(String fileName, Files.FileType type) {
        return new IOSFileHandle(fileName, type);
    }

    @Override
    public FileHandle classpath(String path) {
        return new IOSFileHandle(path, Files.FileType.Classpath);
    }

    @Override
    public FileHandle internal(String path) {
        return new IOSFileHandle(path, Files.FileType.Internal);
    }

    @Override
    public FileHandle external(String path) {
        return new IOSFileHandle(path, Files.FileType.External);
    }

    @Override
    public FileHandle absolute(String path) {
        return new IOSFileHandle(path, Files.FileType.Absolute);
    }

    @Override
    public FileHandle local(String path) {
        return new IOSFileHandle(path, Files.FileType.Local);
    }

    @Override
    public String getExternalStoragePath() {
        return externalPath;
    }

    @Override
    public boolean isExternalStorageAvailable() {
        return true;
    }

    @Override
    public String getLocalStoragePath() {
        return localPath;
    }

    @Override
    public boolean isLocalStorageAvailable() {
        return true;
    }
}

