/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.math.MathUtils;
import org.robovm.apple.audiotoolbox.AudioServices;
import org.robovm.apple.corehaptic.CHHapticEngine;
import org.robovm.apple.corehaptic.CHHapticEventParameterID;
import org.robovm.apple.corehaptic.CHHapticEventType;
import org.robovm.apple.corehaptic.CHHapticPattern;
import org.robovm.apple.corehaptic.CHHapticPatternDict;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSProcessInfo;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.apple.uikit.UIImpactFeedbackGenerator;
import org.robovm.apple.uikit.UIImpactFeedbackStyle;
import org.robovm.apple.uikit.UIUserInterfaceIdiom;
import org.robovm.objc.block.VoidBlock1;

public class IOSHaptics {
    private CHHapticEngine hapticEngine;
    private boolean hapticsSupport;
    private final boolean vibratorSupport;

    public IOSHaptics(boolean useHaptics) {
        boolean bl = this.vibratorSupport = useHaptics && UIDevice.getCurrentDevice().getUserInterfaceIdiom() == UIUserInterfaceIdiom.Phone;
        if (NSProcessInfo.getSharedProcessInfo().getOperatingSystemVersion().getMajorVersion() >= 13L) {
            boolean bl2 = this.hapticsSupport = useHaptics && CHHapticEngine.capabilitiesForHardware().supportsHaptics();
            if (this.hapticsSupport) {
                try {
                    this.hapticEngine = new CHHapticEngine();
                }
                catch (NSErrorException e) {
                    Gdx.app.error("IOSHaptics", "Error creating CHHapticEngine. Haptics will be disabled. " + (Object)((Object)e));
                    this.hapticsSupport = false;
                    return;
                }
                this.hapticEngine.setPlaysHapticsOnly(true);
                this.hapticEngine.setAutoShutdownEnabled(true);
                this.hapticEngine.setResetHandler(new Runnable(){

                    @Override
                    public void run() {
                        IOSHaptics.this.hapticEngine.start((VoidBlock1)new VoidBlock1<NSError>(){

                            public void invoke(NSError nsError) {
                                if (nsError != null) {
                                    Gdx.app.error("IOSHaptics", "Error restarting CHHapticEngine. Haptics will be disabled.");
                                    IOSHaptics.this.hapticsSupport = false;
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    public void vibrate(int milliseconds, boolean fallback) {
        if (this.hapticsSupport) {
            CHHapticPatternDict hapticDict = this.getChHapticPatternDict(milliseconds, 0.5f);
            try {
                CHHapticPattern pattern = new CHHapticPattern(hapticDict);
                NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
                this.hapticEngine.createPlayer(pattern).start(0.0, ptr);
                if (ptr.get() != null) {
                    Gdx.app.error("IOSHaptics", "Error starting haptics player. Error code: " + ((NSError)ptr.get()).getLocalizedDescription());
                }
            }
            catch (NSErrorException e) {
                Gdx.app.error("IOSHaptics", "Error creating haptics pattern or player. " + e.getMessage());
            }
        } else if (fallback) {
            AudioServices.playSystemSound((int)4095);
        }
    }

    public void vibrate(int milliseconds, int amplitude, boolean fallback) {
        if (this.hapticsSupport) {
            float intensity = MathUtils.clamp((float)amplitude / 255.0f, 0.0f, 1.0f);
            CHHapticPatternDict hapticDict = this.getChHapticPatternDict(milliseconds, intensity);
            try {
                CHHapticPattern pattern = new CHHapticPattern(hapticDict);
                NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
                this.hapticEngine.createPlayer(pattern).start(0.0, ptr);
                if (ptr.get() != null) {
                    Gdx.app.error("IOSHaptics", "Error starting haptics pattern.");
                }
            }
            catch (NSErrorException e) {
                Gdx.app.error("IOSHaptics", "Error creating haptics player. " + e.getMessage());
            }
        } else {
            this.vibrate(milliseconds, fallback);
        }
    }

    private CHHapticPatternDict getChHapticPatternDict(int milliseconds, float intensity) {
        return new CHHapticPatternDict().setPattern(new NSArray(new NSObject[]{new CHHapticPatternDict().setEvent(new CHHapticPatternDict().setEventType(CHHapticEventType.HapticContinuous).setTime(0.0).setEventDuration((double)((float)milliseconds / 1000.0f)).setEventParameters(new NSArray(new NSObject[]{new CHHapticPatternDict().setParameterID(CHHapticEventParameterID.HapticIntensity).setParameterValue((double)intensity).getDictionary()}))).getDictionary()}));
    }

    public void vibrate(Input.VibrationType vibrationType) {
        if (this.hapticsSupport) {
            UIImpactFeedbackStyle uiImpactFeedbackStyle;
            switch (vibrationType) {
                case LIGHT: {
                    uiImpactFeedbackStyle = UIImpactFeedbackStyle.Light;
                    break;
                }
                case MEDIUM: {
                    uiImpactFeedbackStyle = UIImpactFeedbackStyle.Medium;
                    break;
                }
                case HEAVY: {
                    uiImpactFeedbackStyle = UIImpactFeedbackStyle.Heavy;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown VibrationType " + (Object)((Object)vibrationType));
                }
            }
            UIImpactFeedbackGenerator uiImpactFeedbackGenerator = new UIImpactFeedbackGenerator(uiImpactFeedbackStyle);
            uiImpactFeedbackGenerator.impactOccurred();
        }
    }

    public boolean isHapticsSupported() {
        return this.hapticsSupport;
    }

    public boolean isVibratorSupported() {
        return this.vibratorSupport;
    }
}

