/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.robovm.apple.foundation.NSAutoreleasePool;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;

public class IOSPreferences
implements Preferences {
    NSMutableDictionary<NSString, NSObject> nsDictionary;
    File file;

    public IOSPreferences(NSMutableDictionary<NSString, NSObject> nsDictionary, String filePath) {
        this.nsDictionary = nsDictionary;
        this.file = new File(filePath);
    }

    @Override
    public Preferences putBoolean(String key, boolean val) {
        this.nsDictionary.put((NSObject)this.convertKey(key), (NSObject)NSNumber.valueOf((boolean)val));
        return this;
    }

    @Override
    public Preferences putInteger(String key, int val) {
        this.nsDictionary.put((NSObject)this.convertKey(key), (NSObject)NSNumber.valueOf((int)val));
        return this;
    }

    @Override
    public Preferences putLong(String key, long val) {
        this.nsDictionary.put((NSObject)this.convertKey(key), (NSObject)NSNumber.valueOf((long)val));
        return this;
    }

    @Override
    public Preferences putFloat(String key, float val) {
        this.nsDictionary.put((NSObject)this.convertKey(key), (NSObject)NSNumber.valueOf((float)val));
        return this;
    }

    @Override
    public Preferences putString(String key, String val) {
        this.nsDictionary.put((NSObject)this.convertKey(key), (NSObject)new NSString(val));
        return this;
    }

    @Override
    public Preferences put(Map<String, ?> vals) {
        Set<String> keySet = vals.keySet();
        for (String key : keySet) {
            Object value = vals.get(key);
            if (value instanceof String) {
                this.putString(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                this.putBoolean(key, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                this.putInteger(key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.putLong(key, (Long)value);
                continue;
            }
            if (!(value instanceof Float)) continue;
            this.putFloat(key, ((Float)value).floatValue());
        }
        return this;
    }

    @Override
    public boolean getBoolean(String key) {
        NSNumber value = (NSNumber)this.nsDictionary.get((Object)this.convertKey(key));
        if (value == null) {
            return false;
        }
        return value.booleanValue();
    }

    @Override
    public int getInteger(String key) {
        NSNumber value = (NSNumber)this.nsDictionary.get((Object)this.convertKey(key));
        if (value == null) {
            return 0;
        }
        return value.intValue();
    }

    @Override
    public long getLong(String key) {
        NSNumber value = (NSNumber)this.nsDictionary.get((Object)this.convertKey(key));
        if (value == null) {
            return 0L;
        }
        return value.longValue();
    }

    @Override
    public float getFloat(String key) {
        NSNumber value = (NSNumber)this.nsDictionary.get((Object)this.convertKey(key));
        if (value == null) {
            return 0.0f;
        }
        return value.floatValue();
    }

    @Override
    public String getString(String key) {
        NSString value = (NSString)this.nsDictionary.get((Object)this.convertKey(key));
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public boolean getBoolean(String key, boolean defValue) {
        if (!this.contains(key)) {
            return defValue;
        }
        return this.getBoolean(key);
    }

    @Override
    public int getInteger(String key, int defValue) {
        if (!this.contains(key)) {
            return defValue;
        }
        return this.getInteger(key);
    }

    @Override
    public long getLong(String key, long defValue) {
        if (!this.contains(key)) {
            return defValue;
        }
        return this.getLong(key);
    }

    @Override
    public float getFloat(String key, float defValue) {
        if (!this.contains(key)) {
            return defValue;
        }
        return this.getFloat(key);
    }

    @Override
    public String getString(String key, String defValue) {
        if (!this.contains(key)) {
            return defValue;
        }
        return this.getString(key);
    }

    @Override
    public Map<String, ?> get() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (NSString key : this.nsDictionary.keySet()) {
            NSObject value = this.nsDictionary.get((Object)key);
            map.put(key.toString(), value.toString());
        }
        return map;
    }

    @Override
    public boolean contains(String key) {
        return this.nsDictionary.containsKey((Object)this.convertKey(key));
    }

    @Override
    public void clear() {
        this.nsDictionary.clear();
    }

    @Override
    public void remove(String key) {
        this.nsDictionary.remove((Object)this.convertKey(key));
    }

    private NSString convertKey(String key) {
        return new NSString(key);
    }

    @Override
    public void flush() {
        NSAutoreleasePool pool = new NSAutoreleasePool();
        if (!this.nsDictionary.write(this.file, false)) {
            Gdx.app.debug("IOSPreferences", "Failed to write NSDictionary to file " + this.file);
        }
        pool.close();
    }
}

