/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm.objectal;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.iosrobovm.IOSApplicationConfiguration;
import com.badlogic.gdx.backends.iosrobovm.IOSAudio;
import com.badlogic.gdx.backends.iosrobovm.IOSMusic;
import com.badlogic.gdx.backends.iosrobovm.IOSSound;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALAudioSession;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALAudioTrack;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALSimpleAudio;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class OALIOSAudio
implements IOSAudio {
    private final IOSApplicationConfiguration config;

    public OALIOSAudio(IOSApplicationConfiguration config) {
        this.config = config;
        if (!config.useAudio) {
            return;
        }
        OALSimpleAudio audio = OALSimpleAudio.sharedInstance();
        if (audio != null) {
            audio.setAllowIpod(config.allowIpod);
            audio.setHonorSilentSwitch(!config.overrideRingerSwitch);
        } else {
            Gdx.app.error("IOSAudio", "No OALSimpleAudio instance available, audio will not be availabe");
        }
    }

    @Override
    public AudioDevice newAudioDevice(int samplingRate, boolean isMono) {
        return null;
    }

    @Override
    public AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        return null;
    }

    @Override
    public Sound newSound(FileHandle fileHandle) {
        return new IOSSound(fileHandle);
    }

    @Override
    public Music newMusic(FileHandle fileHandle) {
        String path = fileHandle.file().getPath().replace('\\', '/');
        OALAudioTrack track = OALAudioTrack.create();
        if (track != null) {
            return new IOSMusic(track, path);
        }
        throw new GdxRuntimeException("Error creating music audio track");
    }

    @Override
    public boolean switchOutputDevice(String deviceIdentifier) {
        return true;
    }

    @Override
    public String[] getAvailableOutputDevices() {
        return new String[0];
    }

    @Override
    public void didBecomeActive() {
        OALSimpleAudio audio;
        this.forceEndInterruption();
        if (this.config.allowIpod && (audio = OALSimpleAudio.sharedInstance()) != null) {
            audio.setUseHardwareIfAvailable(false);
        }
    }

    @Override
    public void willEnterForeground() {
        this.forceEndInterruption();
    }

    @Override
    public void willResignActive() {
    }

    @Override
    public void willTerminate() {
    }

    private void forceEndInterruption() {
        OALAudioSession audioSession = OALAudioSession.sharedInstance();
        if (audioSession != null) {
            audioSession.forceEndInterruption();
        }
    }
}

