/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.message.saaj.SAAJFactory;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class SOAPMessageContextImpl
extends MessageUpdatableContext
implements SOAPMessageContext {
    private Set<String> roles;
    private SOAPMessage soapMsg = null;
    private WSBinding binding;

    public SOAPMessageContextImpl(WSBinding wSBinding, Packet packet, Set<String> set) {
        super(packet);
        this.binding = wSBinding;
        this.roles = set;
    }

    @Override
    public SOAPMessage getMessage() {
        if (this.soapMsg == null) {
            try {
                Message message = this.packet.getMessage();
                this.soapMsg = message != null ? message.readAsSOAPMessage() : null;
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }
        return this.soapMsg;
    }

    @Override
    public void setMessage(SOAPMessage sOAPMessage) {
        try {
            this.soapMsg = sOAPMessage;
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    @Override
    void setPacketMessage(Message message) {
        if (message != null) {
            this.packet.setMessage(message);
            this.soapMsg = null;
        }
    }

    @Override
    protected void updateMessage() {
        if (this.soapMsg != null) {
            this.packet.setMessage(SAAJFactory.create(this.soapMsg));
            this.soapMsg = null;
        }
    }

    @Override
    public Object[] getHeaders(QName qName, JAXBContext jAXBContext, boolean bl) {
        SOAPVersion sOAPVersion = this.binding.getSOAPVersion();
        ArrayList arrayList = new ArrayList();
        try {
            Iterator<Header> iterator = this.packet.getMessage().getHeaders().getHeaders(qName, false);
            if (bl) {
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next().readAsJAXB(jAXBContext.createUnmarshaller()));
                }
            } else {
                while (iterator.hasNext()) {
                    Header header = iterator.next();
                    String string = header.getRole(sOAPVersion);
                    if (!this.getRoles().contains(string)) continue;
                    arrayList.add(header.readAsJAXB(jAXBContext.createUnmarshaller()));
                }
            }
            return arrayList.toArray();
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }
}

